---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-All Stages（全ステージ一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **PoolTableの表示カラム詳細**：PoolTable.scalaの直接読解が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` （AllStagesPageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` （StagesTabクラス全体）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.3の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.3の関連機能）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` （StagesTab内の遷移関係）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /stages/ | E-01 (30行目: WebUIPage("")) + E-02 (31行目: SparkUITab(parent, "stages")) | ○ |
| C-02 | ステージは5つのステータスに分類される | E-01 (43-44行目: allStatuses定義) | ○ |
| C-03 | store.stageList(null)で全ステージを取得 | E-01 (46行目) | ○ |
| C-04 | FAIRスケジューラ時にPool一覧を表示 | E-01 (59-72行目: isFairScheduler判定) | ○ |
| C-05 | Pool情報はsc.getAllPoolsから取得 | E-01 (36行目: sc.map(_.getAllPools)) | ○ |
| C-06 | Pool情報をstore.pool()と突合 | E-01 (37-38行目: store.pool(pool.name)) | ○ |
| C-07 | Failed StagesはReverseで新しい順に表示 | E-01 (84-86行目: if (status == StageStatus.FAILED) stages.reverse) | ○ |
| C-08 | KillはACTIVEステータスのみ有効 | E-01 (93行目: killEnabled = status == StageStatus.ACTIVE && parent.killEnabled) | ○ |
| C-09 | 完了ステージの件数がnumCompletedStagesと異なる場合に注記 | E-01 (117-123行目: summaryContent) | ○ |
| C-10 | StagesTab.handleKillRequestがKill処理を担当 | E-02 (53-68行目) | ○ |
| C-11 | cancelStage引数は"killed via the Web UI" | E-02 (59行目) | ○ |
| C-12 | ACTIVEまたはPENDING状態のステージのみKill可能 | E-02 (58行目: status == StageStatus.ACTIVE || status == StageStatus.PENDING) | ○ |
| C-13 | Kill後100ms待機 | E-02 (63行目: Thread.sleep(100)) | ○ |
| C-14 | セクションは折りたたみ可能 | E-01 (147-158行目: collapse-aggregated class) | ○ |
| C-15 | FAIRスケジューラ判定はlive UIのみ | E-02 (45-51行目: sc.isDefined条件) | ○ |
| C-16 | サマリーのCompleted部分にid属性が設定される | E-01 (134-135行目: "completed-summary") | ○ |
| C-17 | ステータス名の大文字化はcapitalizeで行われる | E-01 (115行目: headerDescription) | ○ |
| C-18 | PoolTableが使用される | E-01 (41行目: new PoolTable(pools, parent)) | ○ |
| C-19 | ページタイトルは"Stages for All Jobs" | E-01 (76行目) | ○ |
| C-20 | PoolTableのカラム定義にはminShare/weightが含まれる | **根拠なし**（PoolTable.scalaの直接読解なし） | △ |

## 4) 不足情報（Unknown / Missing）
- PoolTable.scalaの詳細なカラム定義と行レンダリング
  - 候補：`core/src/main/scala/org/apache/spark/ui/jobs/PoolTable.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理フローはAllStagesPage.scalaで完全に確認済み
- 0: 低リスク - Kill処理はStagesTab.scalaで確認済み
- 1: 中リスク - PoolTableの表示内容は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] FAIRスケジューラ判定ロジックが正確に記載されているか確認
- [ ] PoolTable表示カラムの実装との一致を確認
- [ ] Kill操作の対象ステータス制限が正確か確認
